--[[
    
dofile("functions_Fabian.lua")

clone_table
CloneMatrix
CombineBlockMatrices
Complex_ToString
get_basis_NF
HAFM_A0_k
HAFM_gamma_k
HAFM_I0_k
HAFM_I1_k
HAFM_S_w_k
HAFM_u_k   
HAFM_v_k   
HAFM_w_k
HAFM_corrected_A_k
HAFM_corrected_gamma_k
HAFM_corrected_I_k
HAFM_q_to_line
HAFM_q_to_qxyz
HAFM_corrected_S1_w_k
HAFM_corrected_S1_w_k_new
HAFM_corrected_S2_w_k
HAFM_corrected_S2_w_k_new
HAFM_corrected_S2_w_k_string
HAFM_corrected_table_wk_Ik
HAFM_corrected_table_wk_Ik_new
HAFM_corrected_table_wk_Ik_string
HAFM_corrected_u_k
HAFM_corrected_v_k
HAFM_corrected_w_k
HAFM_corrected_w0_k
HAFM_corrected_w1_k
HFM_gamma_k
HFM_w_k
HFM_S1_w_k
HFM_S2_w_k
integrate_table
Lorentzian
Matrix_add
Matrix_multiply
Matrix_scale
Matrix_transpose
Matrix_zero
MatrixToOperator
print_expectation_values
print_matrix_elements
print_overlap
print_overlap_matrix
RestrictMatrix
RIXS_include_self_absorption
RIXS_include_self_absorption_in_out
RIXS_print_resonance
resonance_include_self_absorption_in_out
Spectra_print_maxima
Spectra_put
Spectra_remove_Name
Spectra_sq
structure_factor
table_from_dat
table_from_file
table_RIXS_print_resonance
table_RIXS_print_resonance_table
table_RIXS_subtract_elastic
table_spectrum_get_maxima
Vector_asterisk
Vector_cross
Vector_dot
Vector_zero
   
--]]

Verbosity(0)

directory = "data/"




phys = {}
phys["kB"] = EnergyUnits.K.value
phys["h"] = PhysicalConstants.hbar.value*EnergyUnits.J.value*2*math.pi
phys["hbar"] = PhysicalConstants.hbar.value*EnergyUnits.J.value
phys["c"] = PhysicalConstants.c.value
phys["J"] = EnergyUnits.J.value
phys["Ryd"] = EnergyUnits.Ryd.value







function MatrixToOperator(matrix, startIndex)
  operator = 0
  for i = 1, #matrix do
    for j = 1, #matrix do
      weight = matrix[i][j]
      operator = operator + NewOperator("Number", startIndex + #matrix, i + startIndex - 1, j + startIndex - 1)*weight
    end
  end
  return operator
end

function CloneMatrix(matrix)
    out = {}
    for i = 1, #matrix do
        out[i] = {}
        for j = 1, #matrix[i] do
            out[i][j] = matrix[i][j]
        end
    end
    return out
end

function RestrictMatrix(matrix, indices)
    out = CloneMatrix(matrix)  
    for i = 1, #out do
        bool = false
        for index = 1, #indices do
            if indices[index] == i then
                bool = true
            end
        end
        if not bool then
            for j = 1, #out[i] do
                out[i][j] = 0
            end
        end
    end
    return out
end

function CombineBlockMatrices(matrix1, matrix2)
    out = {}
    for i = 1, #matrix1 + #matrix2 do
        out[i] = {}
        for j =1, #matrix1[1] + #matrix2[1] do
        --insert block for 2p rotation 
            if i < #matrix1 + 1 and j < #matrix1[1] + 1 then
            out[i][j] = matrix1[i][j]
        --insert block for 3d rotation
            elseif i >= #matrix1 + 1 and j >= #matrix1[1] + 1 then
            out[i][j] = matrix2[i-#matrix1][j-#matrix1[1]]
        --any other element is set to zero    
            else
            out[i][j] = 0
            end
        end
    end
    return out
end

function clone_table(in_table)
    
    if type(in_table) == "table" then
    
        local out_table = {}
               
        for i, v in pairs(in_table) do
            
            out_table[i] = clone_table(v)
            
        end
        
        return out_table
        
    else
        
        return in_table
        
    end  
end

function RIXS_print_resonance(in_RIXS, energyloss, out_resonance)
    -- iterate rows in RIXS data
    for row in io.lines(in_RIXS) do
        
        local row_found = false
        local out = {}
        local first_entry = string.match(row, "[^ ]+")
        -- select row of desired energyloss
        if tonumber(first_entry) ~= nil and tonumber(first_entry) >= energyloss then
            
            row_found = true
            
            for entry in string.gmatch(row, "[^ ]+") do
                    table.insert(out, tonumber(entry))
            end
        end
        
        -- transpose row to column and write in new file: i, Re, Im
        if row_found then
            
            local OUT = io.open(out_resonance, "w")
            io.output(OUT)
            
            for i, entry in pairs(out) do
                if i%2 == 0 then
                    io.write(string.format("%.15e %.15e ", i/2 - 1, entry))
                elseif i > 1 and i%2 > 0 then
                    io.output(OUT)
                    io.write(string.format("%.15e\n", entry))
                end
            end
            io.close(OUT)
            break
        end
    end

end

function Spectra_print_maxima(in_spectrum, out_maxima, column, column_sign, min_width)
    
    -- copy al data into table
    local rows = {}
    
    for row in io.lines(in_spectrum) do

        local entries = {}
        local i = 1
              
        if tonumber(string.match(row, "[^%s]+")) ~= nil then
            for entry in string.gmatch(row, "[^%s]+") do
                if i == 1 then
                    table.insert(entries, tonumber(entry))
                elseif i == column then
                    table.insert(entries, tonumber(entry)*column_sign)
                end
                i = i + 1
            end        
            table.insert(rows, entries)
        end
    end

    -- print local maxima
    local OUT = io.open(out_maxima, "w")
    io.output(OUT)

    for i = 2, #rows - min_width do
        if  rows[i][2] > rows[i - 1][2] and rows[i][2] > rows[i + 1][2] then -- detect maximum
            
            local width = 1
            
            while i + width + 1 <= #rows and rows[i + width][2] > rows[i + width + 1][2] do -- measure (half) width of maximum
                
                width = width + 1
                
            end
            
            if width >= min_width then -- restrict to minimum width of maximum
                
                io.write(string.format("%.15e ", rows[i][1]))
            end
        end
    end
    io.close(OUT)

end

function RIXS_include_self_absorption(in_RIXS, energyshift_1, absorption, energyshift_2, column, sign, alpha, beta, offset)
    
    local table_absorption = {}
    
    for row in io.lines(absorption) do

        local entries = {}
              
        if tonumber(string.match(row, "[^%s]+")) ~= nil then
            for entry in string.gmatch(row, "[^%s]+") do
                table.insert(entries, tonumber(entry))
            end
            table.insert(table_absorption, entries)
        end
    end
    
   
    local out_RIXS = clone_table(in_RIXS)
    
    for i = 1, #out_RIXS do
                
        for j = 1, #out_RIXS[i] do
                        
            local energy_in = out_RIXS[i].ResonantEnergy + energyshift_1
            local energy_out = energy_in - out_RIXS[i][j][1]
            
            local absorption_in = 1
            local absorption_out = 1


            for k = 1, #table_absorption do
                               
                if table_absorption[k][1] + energyshift_2 >= energy_in then
                    
                    absorption_in = sign*table_absorption[k][column] + offset
                    break
                    
                end
            end
            


            for k = 1, #table_absorption do
                
                if table_absorption[k][1] + energyshift_2 >= energy_out then
                    
                    absorption_out = sign*table_absorption[k][column] + offset
                    break
                    
                end
            end

            
            local correction = 1/(absorption_in + absorption_out*math.sin(alpha)/math.sin(alpha + beta))
                                   
            out_RIXS[i][j][2] = out_RIXS[i][j][2] * correction
                        
        end
    end

    return out_RIXS
    
end

function RIXS_include_self_absorption_in_out(in_RIXS, energyshift_1, absorption_in, absorption_out, energyshift_2, column, sign, alpha, beta, offset)
    
    local table_absorption_in = {}
    local table_absorption_out = {}
    
    for row in io.lines(absorption_in) do

        local entries = {}
              
        if tonumber(string.match(row, "[^%s]+")) ~= nil then
            for entry in string.gmatch(row, "[^%s]+") do
                table.insert(entries, tonumber(entry))
            end
            table.insert(table_absorption_in, entries)
        end
    end
    
    for row in io.lines(absorption_out) do

        local entries = {}
              
        if tonumber(string.match(row, "[^%s]+")) ~= nil then
            for entry in string.gmatch(row, "[^%s]+") do
                table.insert(entries, tonumber(entry))
            end
            table.insert(table_absorption_out, entries)
        end
    end
    
   
    local out_RIXS = clone_table(in_RIXS)
    
    for i = 1, #out_RIXS do
                
        for j = 1, #out_RIXS[i] do
                        
            local energy_in = out_RIXS[i].ResonantEnergy + energyshift_1
            local energy_out = energy_in - out_RIXS[i][j][1]
            
            local absorption_in = 1
            local absorption_out = 1


            for k = 1, #table_absorption_in do
                               
                if table_absorption_in[k][1] + energyshift_2 >= energy_in then
                    
                    absorption_in = sign*table_absorption_in[k][column] + offset
                    break
                    
                end
            end
            


            for k = 1, #table_absorption_out do
                
                if table_absorption_out[k][1] + energyshift_2 >= energy_out then
                    
                    absorption_out = sign*table_absorption_out[k][column] + offset
                    break
                    
                end
            end

            
            local correction = 1/(absorption_in + absorption_out*math.sin(alpha)/math.sin(alpha + beta))
                                   
            out_RIXS[i][j][2] = out_RIXS[i][j][2] * correction
                        
        end
    end

    return out_RIXS
    
end

function resonance_include_self_absorption_in_out(table_in_resonance, energyshift, energyloss, table_absorption_in, table_absorption_out, alpha, beta)
    
    local table_out_resonance = clone_table(table_in_resonance)
                  
        for i = 1, #table_out_resonance do
            
            energy_in = table_out_resonance[i][1] + energyshift
                                  
            local absorption_in = 1
            local absorption_out = 1

            for j = 1, #table_absorption_in do
                               
                if table_absorption_in[j][1] >= energy_in then
                    
                    absorption_in = Complex.Im(table_absorption_in[j][2])
                    break
                    
                end
            end

            for j = 1, #table_absorption_out do
                
                if table_absorption_out[j][1] >= energy_in - energyloss then
                    
                    absorption_out = Complex.Im(table_absorption_out[j][2])
                    break
                    
                end
            end

            
            local correction = 1/(absorption_in + absorption_out*math.sin(alpha)/math.sin(alpha + beta))
                                             
            table_out_resonance[i][2] = table_out_resonance[i][2] * correction
                        
        end

    return table_out_resonance
end

function table_RIXS_print_resonance(in_RIXS, energyloss, step, energyshift, out_resonance)

    local OUT = io.open(out_resonance, "w")
    io.output(OUT)
    
    for i = 1, #in_RIXS do
        
        for j = 1, #in_RIXS[i] do
            
            if in_RIXS[i][j][1] >= energyloss then
                
                io.write(string.format("%.15e %.15e\n", (i - 1)*step + energyshift, -1*Complex.Im(in_RIXS[i][j][2])))
                break
    
            end
        end
    end
    
    io.close(OUT)
end

function table_RIXS_print_resonance_table(in_RIXS, energyloss, step, energyshift)

    out_table = {}
    
    for i = 1, #in_RIXS do
        
        for j = 1, #in_RIXS[i] do
            
            if in_RIXS[i][j][1] >= energyloss then
                
                io.write(string.format("%.15e %.15e\n", (i - 1)*step + energyshift, -1*Complex.Im(in_RIXS[i][j][2])))
                break
    
            end
        end
    end
    
    io.close(OUT)
end

function table_RIXS_subtract_elastic(in_RIXS, energyshift_1, in_elastic, energyshift_2, gamma)

    local table_in_elastic = {}
    
    for row in io.lines(in_elastic) do
        
        local entries = {}
              
        if tonumber(string.match(row, "[^%s]+")) ~= nil then
            
            for entry in string.gmatch(row, "[^%s]+") do
            
                table.insert(entries, tonumber(entry))
            
            end
                        
            table.insert(table_in_elastic, entries)
        end
    end
       
    
    local function Lorentzian(omega, max)
        
        return 0.5*gamma/(math.pi*(omega^2 + (0.5*gamma)^2))*max/2*math.pi*gamma
        
    end
    
    local out_RIXS = clone_table(in_RIXS)
    
    for i = 1, #out_RIXS do
                
        energy_in = out_RIXS[i].ResonantEnergy + energyshift_1
        
        for k = 1, #table_in_elastic do
            
            if table_in_elastic[k][1] + energyshift_2 >= energy_in then

                for j = 1, #out_RIXS[i] do
                                        
                    out_RIXS[i][j][2] = out_RIXS[i][j][2] + I*Lorentzian(out_RIXS[i][j][1], table_in_elastic[k][2])
                    
                end
                
                break
                
            end
        end
    end
    
    return out_RIXS
    
end

function table_from_dat(dat)
   
    for row in io.lines(dat) do
        
        print(row)
    
    end
    
end

function table_spectrum_get_maxima(spectrum)
    
    values = {-100000000, -100000000, -100000000}
    maxima = {}
    
    for i = 1, #spectrum[1] do
                  
        table.remove(values, 1)
        table.insert(values, Complex.Im(spectrum[1][i][2]))
                   
        if values[1] > values[2] and values [2] < values[3] then
        
            table.insert(maxima, i - 1)
        end
    end
    
    return maxima
end

function Matrix_zero(m, n)
    
    local out = {}
     
    for i = 1, m do
        
        local temp = {}
        
        for j = 1, n do
            
            table.insert(temp, 0)
        end
        
        table.insert(out, temp)
    end
    
    return out
end

function Matrix_transpose(matrix)
       
    local m = #matrix
    local n = #matrix[1]
       
    local out = Matrix_zero(n, m)
    
    for j = 1, m do
        
        for k = 1, n do
            
            out[k][j] = matrix[j][k]
            
        end
    end
           
    return out  
end

function Matrix_conjugate(matrix)
       
    local m = #matrix
    local n = #matrix[1]
       
    local out = Matrix_zero(m, n)
    
    for j = 1, m do
        
        for k = 1, n do
            
            out[j][k] = Conjugate(matrix[j][k])
            
        end
    end
           
    return out  
end

function Matrix_add(matrices)
      
    local m = #matrices[1]
    local n = #matrices[1][1]
       
    local out = Matrix_zero(m, n)
    
    for i, matrix in pairs(matrices) do

        for j = 1, m do
            
            for k = 1, n do
                
                out[j][k] = out[j][k] + matrix[j][k]
                
            end
        end
        
    end
    
    return out
end

function Matrix_multiply(matrices)
           
    if #matrices < 2 then
           
        return matrices[1]
    end

    local B = table.remove(matrices, #matrices)
    local A = table.remove(matrices, #matrices)

    if (type(A) == "table" and type(B) ~= "table") or (type(A) ~= "table" and type(B) == "table") then
        
        table.insert(matrices, Matrix_scale(A, B))
        return Matrix_multiply(matrices)
    elseif type(A) ~= "table" and type(B) ~= "table" then
        
        table.insert(matrices, A*B)
        return Matrix_multiply(matrices)
    end
        
    
    local m = #A
    local n = #A[1]
    local o = #B
    local p = #B[1]
       
    if o ~= n then
        
        print("undefined multiplication:", m.."x"..n.." * "..o.."x"..p)
        return nil
    end
    
    local out = Matrix_zero(m, p)
                
    for i = 1, p do

        for j = 1, m do
            
            local temp = 0
            
            for k = 1, n do
                
                temp = temp + A[j][k]*B[k][i]
                
            end
            
            out[j][i] = temp
        end
    end
    
    if #out == 1 and #out[1] == 1 then
        
        out = out[1][1]
    end
        
    table.insert(matrices, out)
       
    return Matrix_multiply(matrices)
end

function Matrix_scale(A, B)
    
    local matrix = {}
    local scalar = 0
    local left = false
    
    if type(A) == "table" and type(B) ~= "table" then
        
        matrix = clone_table(A)
        scalar = B
        
    elseif type(A) ~= "table" and type(B) == "table" then
        
        matrix = clone_table(B)
        scalar = A
        left = true
    elseif type(A) ~= "table" and type(B) ~= "table" then

        print("undefined scaling:", "at least one table needed")
        return nil
    else       
        
        print("undefined scaling:", "at least one scalar needed")
        return nil
    end
    
    if scalar == inf then
        
        return matrix
    end
       
    for i = 1, #matrix do
        
        for j = 1, #matrix[1] do
            
            if left then

                matrix[i][j] = scalar*matrix[i][j]
            else

                matrix[i][j] = matrix[i][j] * scalar
            end
        end
    end
    
    return matrix
end

function Matrix_identity(n)
    
    out = Matrix_zero(n, n)
    
    for i = 1, n do
        
        out[i][i] = 1
    end

    return out
end

function spectrum_sq(table_in_spectrum)
    
   local table_out_spectrum = clone_table(table_in_spectrum)
     
   for i = 1, #table_out_spectrum do
       
        for j = 1, #table_out_spectrum[1] do
            
            table_out_spectrum[i][j][2] = Complex.Re(table_in_spectrum[i][j][2])*Complex.Re(table_in_spectrum[i][j][2]) + Complex.Im(table_in_spectrum[i][j][2])*Complex.Im(table_in_spectrum[i][j][2])
        end
   end
   
   return table_out_spectrum
end

function HAFM_gamma_k(k, hoppings, lattice)

    out = 0
    
    k = Matrix.Transpose(k)
    
    for i, hopping in pairs(hoppings) do
        
        out = out + hopping*2*math.cos((lattice[i]*k)[1][1])
    end
    
    return Complex.Re(out)
end

function HAFM_u_k(k, hoppings, lattice)
    
    return math.sqrt(HAFM_gamma_k({{0, 0, 0}}, hoppings, lattice)/(2*math.sqrt(HAFM_gamma_k({{0, 0, 0}}, hoppings, lattice)^2 - HAFM_gamma_k(k, hoppings, lattice)^2)) + 1/2)
end

function HAFM_v_k(k, hoppings, lattice)
    
    return math.sqrt(HAFM_u_k(k, hoppings, lattice)^2 - 1)*HAFM_gamma_k(k, hoppings, lattice)/math.abs(HAFM_gamma_k(k, hoppings, lattice))
end

function HAFM_w_k(k, hoppings, lattice)
    
    return math.sqrt(HAFM_gamma_k({{0, 0, 0}}, hoppings, lattice)^2 - HAFM_gamma_k(k, hoppings, lattice)^2)
end

function HAFM_A0_k(k, hoppings, lattice)
    
    return HAFM_u_k(k, hoppings, lattice) - HAFM_v_k(k, hoppings, lattice)
end

function HAFM_I0_k(k, hoppings, lattice)
    
    return (HAFM_u_k(k, hoppings, lattice) - HAFM_v_k(k, hoppings, lattice))^2
end

function HAFM_I1_k(k, hoppings, lattice, amplitudes, sublattices)
       
    local amplitudes = clone_table(amplitudes)
    local A0 = HAFM_A0_k(k, hoppings, lattice)
    local A1 = A0*table.remove(amplitudes, 1)
             
    for i, amplitude in pairs(amplitudes) do
     
        A1 = A1 + A0*amplitude*math.exp(I*(sublattices[i]*Matrix.Transpose(k))[1][1])
    end
  
    return Complex.Re(A1*Conjugate(A1))/(#amplitudes + 1)
end

function Lorentzian(w, w0, gamma)

    return 0.5*gamma/(math.pi*((w - w0)^2 + (0.5*gamma)^2))

end

function HAFM_S_w_k(w, k, hoppings, lattice, gamma, I1 ,amplitudes, sublattices)
    
    local w0 = HAFM_w_k(k, hoppings, lattice)
    
    if(I1 == nil) then
        
        I1 = HAFM_I1_k(k, hoppings, lattice, amplitudes, sublattices)
    end
    
    return I1*Lorentzian(w, w0, gamma)
end

function Vector_dot(A, B)
    
    return A[1][1]*B[1][1] + A[2][1]*B[2][1] + A[3][1]*B[3][1] 
end

function Vector_cross(A, B)
    
    local out = Matrix_zero(3, 1)
       
    out[1][1] = A[2][1]*B[3][1] - A[3][1]*B[2][1]
    out[2][1] = A[3][1]*B[1][1] - A[1][1]*B[3][1]
    out[3][1] = A[1][1]*B[2][1] - A[2][1]*B[1][1]   
    return out
end

function Vector_asterisk(A, B)
    
    local out = Matrix_zero(3, 1)
    
    out[1][1] = A[1][1]*B[1][1]
    out[2][1] = A[2][1]*B[2][1]
    out[3][1] = A[3][1]*B[3][1]

    return out
end

function Vector_zero(n)
    
    local out = {}
    
    for i = 1, n do
        
        table.insert(out, 0)
    end
    
    return out
end

function sign(A)
    
    if A >= 0 then
        
        return 1
    else
        
        return -1
    end
end

function HAFM_corrected_gamma_k(k, hoppings, lattice)

    out = 0
    
    k = Matrix.Transpose(k)
    
    for i, hopping in pairs(hoppings) do
        
        out = out + hopping*2*math.cos((lattice[i]*k)[1][1])
        --out = out + hopping*math.exp(I*(lattice[i]*k)[1][1])
    end
    
    return Complex.Re(out)
end

function HAFM_corrected_w0_k(k, hoppingsUD, latticeUD, hoppingsUU, latticeUU)
    
    return HAFM_corrected_gamma_k({{0, 0, 0}}, hoppingsUD, latticeUD) - HAFM_corrected_gamma_k({{0, 0, 0}}, hoppingsUU, latticeUU) + HAFM_corrected_gamma_k(k, hoppingsUU, latticeUU)
end

function HAFM_corrected_w1_k(k, hoppingsUD, latticeUD, hoppingsUU, latticeUU)
    
    return HAFM_corrected_gamma_k(k, hoppingsUD, latticeUD)
end

function HAFM_corrected_u_k(k, hoppingsUD, latticeUD, hoppingsUU, latticeUU)
        
    return math.sqrt(HAFM_corrected_w0_k(k, hoppingsUD, latticeUD, hoppingsUU, latticeUU)/(2*HAFM_corrected_w_k(k, hoppingsUD, latticeUD, hoppingsUU, latticeUU)) + 1/2)
end

function HAFM_corrected_v_k(k, hoppingsUD, latticeUD, hoppingsUU, latticeUU)
    
    return math.sqrt(HAFM_corrected_u_k(k, hoppingsUD, latticeUD, hoppingsUU, latticeUU)^2 - 1)*sign(HAFM_corrected_w1_k(k, hoppingsUD, latticeUD, hoppingsUU, latticeUU))
end

function HAFM_corrected_w_k(k, hoppingsUD, latticeUD, hoppingsUU, latticeUU)
        
    --return math.sqrt(math.abs(HAFM_corrected_w0_k(k, hoppingsUD, latticeUD, hoppingsUU, latticeUU)^2 - HAFM_corrected_w1_k(k, hoppingsUD, latticeUD, hoppingsUU, latticeUU)^2))
    return math.sqrt(HAFM_corrected_w0_k(k, hoppingsUD, latticeUD, hoppingsUU, latticeUU)^2 - HAFM_corrected_w1_k(k, hoppingsUD, latticeUD, hoppingsUU, latticeUU)^2)
    
end

function HAFM_corrected_A_k(k, hoppingsUD, latticeUD, hoppingsUU, latticeUU)
    
    return (HAFM_corrected_u_k(k, hoppingsUD, latticeUD, hoppingsUU, latticeUU) - HAFM_corrected_v_k(k, hoppingsUD, latticeUD, hoppingsUU, latticeUU))
end

function HAFM_corrected_I_k(k, hoppingsUD, latticeUD, hoppingsUU, latticeUU)
    
    return HAFM_corrected_A_k(k, hoppingsUD, latticeUD, hoppingsUU, latticeUU)^2
end

function HAFM_corrected_I_k_new(k, hoppingsUD, latticeUD, hoppingsUU, latticeUU, I_Splus, I_SplusSz)
    
    return (HAFM_corrected_u_k(k, hoppingsUD, latticeUD, hoppingsUU, latticeUU) - HAFM_corrected_v_k(k, hoppingsUD, latticeUD, hoppingsUU, latticeUU))^2
end

function HAFM_corrected_M_sq_k(k, hoppingsUD, latticeUD, hoppingsUU, latticeUU)
    
    return (HAFM_corrected_w0_k(k, hoppingsUD, latticeUD, hoppingsUU, latticeUU) - HAFM_corrected_w1_k(k, hoppingsUD, latticeUD, hoppingsUU, latticeUU))/HAFM_corrected_w_k(k, hoppingsUD, latticeUD, hoppingsUU, latticeUU)
end

function HAFM_corrected_S1_w_k(w, k, hoppingsUD, latticeUD, hoppingsUU, latticeUU, gamma, w_k, I1_k)
    
    if w_k == nil then
    
        w_k = HAFM_corrected_w_k(k, hoppingsUD, latticeUD, hoppingsUU, latticeUU)
    end
    
    if I1_k == nil then
        
        I1_k = HAFM_corrected_I_k(k, hoppingsUD, latticeUD, hoppingsUU, latticeUU)
    end
    
    return I1_k*Lorentzian(w, w_k, gamma)
end

function HAFM_corrected_table_wk_Ik(hoppingsUD, latticeUD, hoppingsUU, latticeUU, Nqx, Nqy, Nqz)
    
    local out = {}
    
    for qx = 1, Nqx do
        
        table.insert(out, {})
    
        for qy = 1, Nqy do
            
            table.insert(out[qx], {})
    
            for qz = 1, Nqz do
                
                q = {{(qx - 0.5)*2*math.pi/Nqx, (qy - 0.5)*2*math.pi/Nqx, (qz - 0.5)*2*math.pi/Nqx}}
                
                table.insert(out[qx][qy], {
                    HAFM_corrected_w_k(q, hoppingsUD, latticeUD, hoppingsUU, latticeUU),
                    HAFM_corrected_I_k(q, hoppingsUD, latticeUD, hoppingsUU, latticeUU),
                })
            end
        end
        
        print(qx)
    end
    
    return out
end

function HAFM_corrected_table_wk_Ik_new(hoppingsUD, latticeUD, hoppingsUU, latticeUU, Nqx, Nqy, Nqz, qx0)
    
    local out = {}
        
    if qx0 == nil then
        
        qx0 = 1
    end
    
    for qx = qx0, Nqx do
        
        out[qx] = {}
    
        for qy = 1, Nqy do
            
            table.insert(out[qx], {})
    
            for qz = 1, Nqz do
                
                q = {{(qx - 0.5)*2*math.pi/Nqx, (qy - 0.5)*2*math.pi/Nqx, (qz - 0.5)*2*math.pi/Nqx}}
                
                table.insert(out[qx][qy], {
                    HAFM_corrected_w_k(q, hoppingsUD, latticeUD, hoppingsUU, latticeUU),
                    HAFM_corrected_I_k(q, hoppingsUD, latticeUD, hoppingsUU, latticeUU),
                })
            end
        end
        
        print(qx)
    end
    
    return out
end

function HAFM_corrected_table_wk_Ik_string(hoppingsUD, latticeUD, hoppingsUU, latticeUU, table_Nqx, table_Nqy, table_Nqz, qx0)
    
    local out = ""
    local space = "\t"
        
    if qx0 == nil then
        
        qx0 = 1
    end
    
    for qx = qx0, table_Nqx do
            
        for qy = 1, table_Nqy do
                
            for qz = 1, table_Nqz do
                
                q = {{(qx - 0.5)*2*math.pi/table_Nqx, (qy - 0.5)*2*math.pi/table_Nqy, (qz - 0.5)*2*math.pi/table_Nqz}}
                
--                 out = out..string.format("%.15e%s%.15e\n",  HAFM_corrected_w_k(q, hoppingsUD, latticeUD, hoppingsUU, latticeUU), space,
--                                                             HAFM_corrected_I_k(q, hoppingsUD, latticeUD, hoppingsUU, latticeUU))
                out = out..string.format("%.15e%s%.15e%s%.15e%s%.15e%s%.15e\n", qx, space,
                                                                                qy, space,
                                                                                qz, space, 
                                                                                HAFM_corrected_w_k(q, hoppingsUD, latticeUD, hoppingsUU, latticeUU), space,
                                                                                HAFM_corrected_I_k(q, hoppingsUD, latticeUD, hoppingsUU, latticeUU))
            end
        end
        
        print(qx)
    end
    
    return out
end

function HAFM_q_to_qxyz(q, table_wk_Ik)
            
    local qx = math.ceil(math.abs((q[1][1]/2/math.pi*#table_wk_Ik + 0.50001)%#table_wk_Ik))
    local qy = math.ceil(math.abs((q[1][2]/2/math.pi*#table_wk_Ik[1] + 0.50001)%#table_wk_Ik[1]))
    local qz = math.ceil(math.abs((q[1][3]/2/math.pi*#table_wk_Ik[1][1] + 0.05001)%#table_wk_Ik[1][1]))
    
--     qx = (qx - 0.5)*2*math.pi/#table_wk_Ik
--     qy = (qy - 0.5)*2*math.pi/#table_wk_Ik[1]
--      qz = (qz - 0.5)*2*math.pi/#table_wk_Ik[1][1]
    
    return qx, qy, qz
end

function HAFM_q_to_line(q, table_Nqx, table_Nqy, table_Nqz)
            
    local qx = math.ceil(math.abs((q[1][1]/2/math.pi*table_Nqx + 0.50001)%table_Nqx))
    local qy = math.ceil(math.abs((q[1][2]/2/math.pi*table_Nqy + 0.50001)%table_Nqy))
    local qz = math.ceil(math.abs((q[1][3]/2/math.pi*table_Nqz + 0.05001)%table_Nqz))
    
    return qz + (qy - 1)*(table_Nqz) + (qx - 1)*(table_Nqz*table_Nqy)
end

function HAFM_corrected_S2_w_k(w, k, hoppingsUD, latticeUD, hoppingsUU, latticeUU, gamma, Nqx, Nqy, Nqz)
    
    local out = 0
    local offset = 0.5 --0.54321*3/math.pi
    
    for qx = 0, Nqx - 1 do
    
        for qy = 0, Nqy - 1 do
    
            for qz = 0, Nqz - 1 do
                
                local q = {{(qx + offset)*2*math.pi/Nqx, (qy + offset)*2*math.pi/Nqy, (qz + offset)*2*math.pi/Nqz}}
                local w0 = HAFM_corrected_w_k(k/2 - q, hoppingsUD, latticeUD, hoppingsUU, latticeUU) + HAFM_corrected_w_k(k/2 + q, hoppingsUD, latticeUD, hoppingsUU, latticeUU)
                
                --print( HAFM_corrected_I_k(k/2 - q, hoppingsUD, latticeUD, hoppingsUU, latticeUU), k/2 - q, qx)

                out = out + 1/(Nqx*Nqy*Nqz)*HAFM_corrected_I_k(k/2 - q, hoppingsUD, latticeUD, hoppingsUU, latticeUU)*HAFM_corrected_I_k(k/2 + q, hoppingsUD, latticeUD, hoppingsUU, latticeUU)*Lorentzian(w, w0, gamma)
                
            end
        end
    end

--     print(out)
    return out
end

function HAFM_corrected_S2_w_k_new(w, k, hoppingsUD, latticeUD, hoppingsUU, latticeUU, gamma, Nqx, Nqy, Nqz, table_wk_Ik)
    
    local out = 0
    
    for qx = 0, Nqx - 1 do
    
        for qy = 0, Nqy - 1 do
    
            for qz = 0, Nqz - 1 do
                
                local q = {{(qx + 0.5)*2*math.pi/Nqx, (qy + 0.5)*2*math.pi/Nqy, (qz + 0.5)*2*math.pi/Nqz}}
                local mqx, mqy, mqz  = HAFM_q_to_qxyz(k/2 - q, table_wk_Ik)
                local pqx, pqy, pqz = HAFM_q_to_qxyz(k/2 + q, table_wk_Ik)
                local w0 = table_wk_Ik[mqx][mqy][mqz][1] + table_wk_Ik[pqx][pqy][pqz][1]

                out = out + 1/(Nqx*Nqy*Nqz)*table_wk_Ik[mqx][mqy][mqz][2]*table_wk_Ik[pqx][pqy][pqz][2]*Lorentzian(w, w0, gamma)
            end
        end
    end
    
    return out
end

function HAFM_corrected_S2_w_k_string(w, k, hoppingsUD, latticeUD, hoppingsUU, latticeUU, gamma, Nqx, Nqy, Nqz, table_wk_Ik, table_Nqx, table_Nqy, table_Nqz)
    
    local out = 0
    
    for qx = 0, Nqx - 1 do
    
        for qy = 0, Nqy - 1 do
    
            for qz = 0, Nqz - 1 do
                
                local q = {{(qx + 0.5)*2*math.pi/Nqx, (qy + 0.5)*2*math.pi/Nqy, (qz + 0.5)*2*math.pi/Nqz}}
                local mline  = HAFM_q_to_line(k/2 - q, table_Nqx, table_Nqy, table_Nqz)
                local pline = HAFM_q_to_line(k/2 + q, table_Nqx, table_Nqy, table_Nqz)
                local w0 = table_wk_Ik[mline][1] + table_wk_Ik[pline][1]

                out = out + 1/(Nqx*Nqy*Nqz)*table_wk_Ik[mline][2]*table_wk_Ik[pline][2]*Lorentzian(w, w0, gamma)
            end
        end
    end
    
    return out
end

function HAFM_corrected_S1_w_k_new(w, k, hoppingsUD, latticeUD, hoppingsUU, latticeUU, gamma, table_wk_Ik)
    
    local qx, qy, qz  = HAFM_q_to_qxyz(k, table_wk_Ik)
    
    return table_wk_Ik[qx][qy][qz][2]*Lorentzian(w, table_wk_Ik[qx][qy][qz][1], gamma)
end

function structure_factor(k, sublattices)
    
    local A1 = 0
                  
    for i, sublattice in pairs(sublattices) do
     
        A1 = A1 + math.exp(I*(sublattice*Matrix.Transpose(k))[1][1])
    end
  
    return Complex.Re(A1*Conjugate(A1))/(#sublattices)
end

function HFM_gamma_k(k, hoppings, lattice)

    out = 0
    
    k = Matrix.Transpose(k)
    
    for i, hopping in pairs(hoppings) do
        
        out = out + hopping*2*math.cos((lattice[i]*k)[1][1])
    end
    
    return Complex.Re(out)
end

function HFM_w_k(k, hoppings, lattice)
    
    return HFM_gamma_k({{0, 0, 0}}, hoppings, lattice) - HFM_gamma_k(k, hoppings, lattice)
end

function HFM_S1_w_k(w, k, hoppings, lattice, gamma, w_k)
    
    if w_k == nil then
    
        w_k = HFM_w_k(k, hoppings, lattice)
    end
    
    return Lorentzian(w, w_k, gamma)
end

function HFM_S2_w_k(w, k, hoppings, lattice, gamma, Nqx, Nqy, Nqz)
    
    local out = 0
    local offset = 0.5 --0.50.54321*3/math.pi
    
    for qx = 0, Nqx - 1 do
    
        for qy = 0, Nqy - 1 do
    
            for qz = 0, Nqz - 1 do
                
                local q = {{(qx + offset)*4*math.pi/Nqx, (qy + offset)*4*math.pi/Nqy, (qz + offset)*4*math.pi/Nqz}}
                local w_k = HFM_w_k(k/2 - q, hoppings, lattice) + HFM_w_k(k/2 + q, hoppings, lattice)

                out = out + 1/(Nqx*Nqy*Nqz)*Lorentzian(w, w_k, gamma)
            end
        end
    end
    
    return out
end

function get_basis_NF(N)
    
    local out = {}
    
    for i = 1, N do
        
        local determinant = ""
        
        for j = 1, N do
            
            if(j == i) then
                
                determinant = determinant .."1"
            else
                
                determinant = determinant .."0"
            end
        end
        
        table.insert(out, NewWavefunction(10, 0, {{determinant, 1}}))
        
    end

    return out
end

function Complex_ToString(c, accuracy)
    
    local Re = Complex.Re(c)
    local Im = Complex.Im(c)
    
    if(accuracy == nil) then
    
        if(Re ~= 0 and Im ~= 0) then
        
            return string.format("%+.2f%+.2fI", Re, Im)
        elseif(Re ~= 0 and Im == 0) then
            return string.format("%+.2f ", Re)

        elseif(Re == 0 and Im ~= 0) then

            return string.format("%+.2fI", Im)

        elseif(Re == 0 and Im == 0) then

            return ""
        end
    else
        
        if(Re ~= 0 and Im ~= 0) then
        
            return string.format("%+."..accuracy.."f%+."..accuracy.."fI", Re, Im)
        elseif(Re ~= 0 and Im == 0) then
            
            return string.format("%+."..accuracy.."f ", Re)
        elseif(Re == 0 and Im ~= 0) then

            return string.format("%+."..accuracy.."fI", Im)
        elseif(Re == 0 and Im == 0) then

            return ""
        end
    end
end

function print_overlap_matrix(psiListA, psiListB)

    for i = 1, #psiListB do

        io.write(string.format("psiB %i = ", i))

        for j = 1, #psiListA do
            
            local value = Chop(psiListA[j]*psiListB[i])
            
            if(Complex.Re(Conjugate(value)*value) > 0) then
                
                io.write(string.format("\t(%s)|%i>", Complex_ToString(value), j))
            else
                
                io.write("\t\t")
            end

        end

        io.write("\n")
    end
end

function print_overlap(psiListA, psiListB)

    for i = 1, #psiListB do

        io.write(string.format("psiB %i = ", i))

        for j = 1, #psiListA do
            
            local value = Chop(psiListA[j]*psiListB[i])
            
            if(Complex.Re(Conjugate(value)*value) > 0) then
                
                io.write(string.format("\t(%s)|%i>", Complex_ToString(value), j))
            end

        end

        io.write("\n")
    end
end

function get_operators_NF(NF, indices, rotation_matrix)
    
    if rotation_matrix == nil then 
        
        rotation_matrix = Matrix_identity(NF)
    end
    
    local out = {}
    local map_l = {s = 0, p = 1, d = 2, f = 3, g = 4, h = 5, i = 6, k = 7, l = 8, m = 9, n = 10, o = 11, q = 12, r = 13, t = 14, u = 15, v = 16, w = 17, x = 18, y = 19, z = 20}
    
    out["1"] = NewOperator(NF, NB, {{1}})
       
    for i, index in pairs(indices) do
               
        local name = index[1]
        local n = string.sub(name, 1, 1)
        local l = map_l[string.sub(name, 2, 2)]
        local index_down = index[2]
        local index_up = index[3]
                       
        out["Sx_"..name] =      Rotate(NewOperator("Sx" ,NF, index_up, index_down), rotation_matrix) 
        out["Sy_"..name] =      Rotate(NewOperator("Sy" ,NF, index_up, index_down), rotation_matrix)
        out["Sz_"..name] =      Rotate(NewOperator("Sz" ,NF, index_up, index_down), rotation_matrix)
        out["Ssqr_"..name] =    Rotate(NewOperator("Ssqr" ,NF, index_up, index_down), rotation_matrix)
        out["Splus_"..name] =   Rotate(NewOperator("Splus" ,NF, index_up, index_down), rotation_matrix)
        out["Smin_"..name] =    Rotate(NewOperator("Smin" ,NF, index_up, index_down), rotation_matrix)
        
        out["Lx_"..name] =      Rotate(NewOperator("Lx" ,NF, index_up, index_down), rotation_matrix)
        out["Ly_"..name] =      Rotate(NewOperator("Ly" ,NF, index_up, index_down), rotation_matrix)
        out["Lz_"..name] =      Rotate(NewOperator("Lz" ,NF, index_up, index_down), rotation_matrix)
        out["Lsqr_"..name] =    Rotate(NewOperator("Lsqr" ,NF, index_up, index_down), rotation_matrix)
        out["Lplus_"..name] =   Rotate(NewOperator("Lplus" ,NF, index_up, index_down), rotation_matrix)
        out["Lmin_"..name] =    Rotate(NewOperator("Lmin" ,NF, index_up, index_down), rotation_matrix)
        
        out["Jx_"..name] =      Rotate(NewOperator("Jx" ,NF, index_up, index_down), rotation_matrix)
        out["Jy_"..name] =      Rotate(NewOperator("Jy" ,NF, index_up, index_down), rotation_matrix)
        out["Jz_"..name] =      Rotate(NewOperator("Jz" ,NF, index_up, index_down), rotation_matrix)
        out["Jsqr_"..name] =    Rotate(NewOperator("Jsqr" ,NF, index_up, index_down), rotation_matrix)
        out["Jplus_"..name] =   Rotate(NewOperator("Jplus" ,NF, index_up, index_down), rotation_matrix)
        out["Jmin_"..name] =    Rotate(NewOperator("Jmin" ,NF, index_up, index_down), rotation_matrix)
        
        out["ldots_" ..name] =   Rotate(NewOperator("ldots",NF, index_up, index_down), rotation_matrix)
        
          
        for k = 0, 2*l, 2 do
            
            local k_list = Vector_zero(l + 1)
            
            k_list[k/2 + 1] = 1
                        
            out["F"..k.."_"..name] = Rotate(NewOperator("U", NF, index_up, index_down, k_list), rotation_matrix)
        end
        
        for j, index2 in pairs(indices) do
            
            if j > i then
                
                local name2 = index2[1]
                local n2 = string.sub(name2, 1, 1)
                local l2 = map_l[string.sub(name2, 2, 2)]
                local index_up2 = index2[2]
                local index_down2 = index2[3]
                
                for k = 0, math.min(2*l, 2*l2), 2 do
                    
                    local k_list_F = Vector_zero(math.min(2*l, 2*l2)/2 + 1)
                    local k_list_G = Vector_zero((math.abs(l + l2) - math.abs(l - l2))/2 + 1)
                    
                    k_list_F[k/2 + 1] = 1
                    
                    out["F"..k.."_"..name..name2] = Rotate(NewOperator("U", NF, index_up, index_down, index_up2, index_down2, k_list_F, k_list_G), rotation_matrix)
                end
                
                for k = math.abs(l - l2), math.abs(l + l2), 2 do
                    
                    local k_list_F = Vector_zero(math.min(2*l, 2*l2)/2 + 1)
                    local k_list_G = Vector_zero((math.abs(l + l2) - math.abs(l - l2))/2 + 1)
                    
                    k_list_G[(k - 1)/2 + 1] = 1
                    
                    out["G"..k.."_"..name..name2] = Rotate(NewOperator("U", NF, index_up, index_down, index_up2, index_down2, k_list_F, k_list_G), rotation_matrix)
                end
            end
        end
    end
    
    out["list"] = {}
    
    for i, operator in pairs(out) do
        
        if i ~= "list" then
        
            table.insert(out["list"], i)
        end
    end
    
    table.sort(out["list"])
    
    return out    
end

function print_matrix_elements(psiListA, psiListB, operator, accuracy, spacing, epsilon)
    
    if operator == nil then
        
        operator = NewOperator(NF, NB, {{1}})
    end
    
    if epsilon == nil then
        
        epsilon = 1e-15
    end
    
    if spacing == nil then
        
        spacing = "\t"
    end
    
    for i = 1, #psiListB do

        io.write(string.format("psiB %i = ", i))

        for j = 1, #psiListA do
            
            local value = psiListA[j]*operator*psiListB[i]
            
            if(Chop(Complex.Re(Conjugate(value)*value), epsilon) > 0) then
                
                io.write(string.format("\t(%s)|%i>", Complex_ToString(value, accuracy), j))
            else
                
                io.write(spacing.."\t")
            end

        end

        io.write("\n")
    end
end


function print_expectation_values(psiList, operators, accuracy, spacing, epsilon)
    
    if epsilon == nil then
        
        epsilon = 1e-15
    end
    
    if spacing == nil then
        
        spacing = ""
    end
    
    io.write("\t")
            
    for i, operator in pairs(operators) do
        
        io.write(i.."\t"..spacing)
    end
    
    print()
    
    for i = 1, #psiList do
    
        io.write(string.format("psi %i:", i))

        for j, operator in pairs(operators) do
            
            local value = Chop(psiList[i]*operator*psiList[i], epsilon)
            
            if Complex.Re(Conjugate(value)*value) > 0 then
                
                io.write(string.format("\t%s", Complex_ToString(value, accuracy)))
            else
                
                io.write(spacing.."\t")
            end

        end

        print()
    end
end

function integrate_table(table_in, column_x, column_y, n1, n2)
    
    if column_x == nil then
        
        column_x = 1
    end
    
    if column_y == nil then
        
        column_y = 2
    end

    if n1 == nil then
        
        n1 = 1
    end
    
    if n2 == nil then
        
        n2 = #table_in
    end
    
    out = 0
    
    for n = n1, n2 - 1 do
                
        local deltax = math.abs(table_in[n + 1][column_x] - table_in[n][column_x])
        local deltay = table_in[n + 1][column_y] - table_in[n][column_y]
        
        out = out + deltax*(table_in[n][column_y] + deltay/2)
    end
    
    return out
end

function table_from_file(file_in, column_x, column_y)
    
    if column_x == nil then
        
        column_x = 1
    end
    
    if column_y == nil then
        
        column_y = 2
    end
    
    out = {}
    
    for line in io.lines(file_in) do
        
        local column = 1

        for value in string.gmatch(line, "[^ ]+") do
        
            if column_x == column then
                
                x = tonumber(value)
            end
            
            if column_y == column then
                
                y = tonumber(value)
            end
            
            if x ~= nil and y ~= nil then
                
                table.insert(out, {x, y})
                x = nil
                y = nil
                break
            end
            
            column = column + 1
        end
    end
    
    return out
end

function Spectra_remove_Name(Spectra_in)
    
    local table_Spectra_in = Spectra.ToTable(Spectra_in)
    
    for i = 1, #table_Spectra_in do
        
        table_Spectra_in[i]["Name"] = ""
    end
    
    return Spectra.FromTable(table_Spectra_in)
end












